%LET SYSLAST=SBST2.RANDOM_FINAL;
%LET _CLIENTTASKLABEL='Birthdays';
%LET _CLIENTPROCESSFLOWNAME='Final';
%LET _CLIENTPROJECTPATH='X:\OPD\Hemmeter\SBST\Potential SSI Population2.egp';
%LET _CLIENTPROJECTPATHHOST='S2740R5';
%LET _CLIENTPROJECTNAME='Potential SSI Population2.egp';
%LET _SASPROGRAMFILE='';
%LET _SASPROGRAMFILEHOST='';

GOPTIONS ACCESSIBLE;
rsubmit sy56.spawner;

libname mbrpub2 'ORES.DSSA.PRD.ORTAR.MBRPUB.R201708' access=readonly;

libname sbst2 'ais.p1252.$4598.sbst2';
	
	/*Get all birthdays*/    
data sbst2.birthday;
	set mbrpub2.mbrpub (keep=boan dob bclm_doe_start_1);
run;
proc sort data=sbst2.birthday; by boan bclm_doe_start_1; run; quit;

	/*Calculate age at date of eligibility and keep earliest*/     
data sbst2.birthday;
	set sbst2.birthday;
	by boan bclm_doe_start_1;
	if first.boan;
	age_at_oasdi=floor(yrdif(dob,bclm_doe_start_1,'AGE'));
run;

	/*Only keep the sample*/ 


data sbst2.final_birthdays /*(keep=boan dob age_at_oasdi age_oasdi)*/;
	merge sbst2.birthday sbst2.random_final (keep=boan in=a);
	by boan;
	if a=1;
	
	/*Align FRA*/
if day(dob)=1 then do;
	if month(dob)-1=0 then dob_alt=mdy(12,1,year(dob)-1);
	else dob_alt=mdy(month(dob)-1,1,year(dob));
end;
else dob_alt=mdy(month(dob),1,year(dob));

	
if year(dob_alt)<1943 then date_fra=mdy(month(dob_alt),day(dob_alt),year(dob_alt)+65);
	else if year(dob_alt) ge 1943 and year(dob_alt) lt 1960 then date_fra=mdy(month(dob_alt),day(dob_alt),year(dob_alt)+66);
	else if year(dob_alt) ge 1960 then date_fra=mdy(month(dob_alt),day(dob_alt),year(dob_alt)+67);

if year(dob_alt)=1955 then date_fra=intnx('MONTH',date_fra,2);
	else if year(dob_alt)=1956 then date_fra=intnx('MONTH',date_fra,4);
	else if year(dob_alt)=1957 then date_fra=intnx('MONTH',date_fra,6);
	else if year(dob_alt)=1958 then date_fra=intnx('MONTH',date_fra,8);
	else if year(dob_alt)=1959 then date_fra=intnx('MONTH',date_fra,10);

before_fra=(bclm_doe_start_1<date_fra);
before_62=(age_at_oasdi<62);

	
format dob_alt date_fra mmddyy10.;


run;


endrsubmit;



GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROCESSFLOWNAME=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTPATHHOST=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;
%LET _SASPROGRAMFILEHOST=;

